function F = ss_fun_NK(x)

%% Load model parameters
global M_
% NumberOfParameters = M_.param_nbr;                            % Number of deep parameters.
% for i = 1:NumberOfParameters                                  % Loop...
%   paramname = cell2mat(deblank(M_.param_names(i,:)));                   %    Get the name of parameter i. 
%   eval([ paramname ' = M_.params(' int2str(i) ');']);         %    Get the value of parameter i.
% end  

gy = M_.params(1);
alp = M_.params(2);
delta = M_.params(3);
zzetap = M_.params(4);
zzetaw = M_.params(5);
sigma_c = M_.params(6);
chi = M_.params(7);
phiX = M_.params(8);
xip = M_.params(9);
xiw = M_.params(10);
gammap = M_.params(11);
gammaw = M_.params(12);
PIE_bar = M_.params(13);
g_bar = M_.params(14);
Rn_bar = M_.params(15);
rho_r = M_.params(16);
theta_pie = M_.params(17);
theta_y = M_.params(18);
theta_dy = M_.params(19);
rhoA = M_.params(20);
rhoG = M_.params(21);
rhoMCS = M_.params(22);
rhoMRSS = M_.params(23);
rhoMPS = M_.params(24);
rhoRPS = M_.params(25);
rhoIS = M_.params(26);
sigma_s = M_.params(27);
wr = M_.params(28);
apsi = M_.params(29); 

H       = exp(x(1));

g       = g_bar/100;
betta   = (PIE_bar/100+1)/(Rn_bar/100+1)/(1+g)^(-sigma_c); % (273)

A       = 1;
MCS     = 1;
MRSS    = 1;
IS      = 1;
MPS     = 1;
RPS     = 1;

PIE     = PIE_bar/100+1;

S       = 0; % (228)
Sdash   = 0; % (229)
PIEw    = (1+g)*PIE; % (230)
Q       = 1; % (231)
LAMBDA  = betta*(1+g)^(-sigma_c); % (232)
rK      = 1/LAMBDA-(1-delta); % (233)
PO      = ((1-xip*PIE^((gammap-1)*(1-zzetap)))/(1-xip))^(1/(1-zzetap)); % (234)
Deltap  = (1-xip)/(1-xip*PIE^(zzetap*(1-gammap)))*PO^(-zzetap); % (235)
MC      = (1-1/zzetap)*1/MCS*(1-xip*(1+g)*LAMBDA*PIE^(zzetap*(1-gammap)))/(1-xip*(1+g)*LAMBDA*PIE^((zzetap-1)*(1-gammap)))*PO; % (236)
PWP     = MC; % (237)
WO      = ((1-xiw*PIE^(gammaw*(1-zzetaw))*PIEw^(zzetaw-1))/(1-xiw))^(1/(1-zzetaw)); % (238)
Deltaw  = (1-xiw)/(1-xiw*PIEw^(zzetaw)/PIE^(gammaw*zzetaw))*WO^(-zzetaw); % (239)
Hd      = H/Deltaw; % (240)
KYW     = (1-alp)*(1+g)/(rK)*PWP; % (241)
YW      = A*Hd*(KYW/(1+g))^((1-alp)/alp); % (242)
K       = YW*KYW; % (243)
Y       = YW/Deltap; % (244)
I       = K/IS*(g+delta)/(1+g); % (245)
G       = gy*Y; % (246)
C       = Y-G-I; % (247)
JJw     = Hd/(1-xiw*LAMBDA*PIEw^zzetaw*PIE^(gammaw*(1-zzetaw)-1)); % (248)
W       = alp*PWP*YW/Hd; % (249)
Jw      = WO*W*JJw; % (250)
Wh      = (1-xiw*(1+g)*LAMBDA*PIEw^zzetaw/PIE^(gammaw*zzetaw))*(1-1/zzetaw)*Jw/(Hd*MRSS); % (251)
U       = (C*(1-chi/(1+g)))^(1-sigma_c)/(1-sigma_c)*exp((sigma_c-1)*H^(1+apsi)/(1+apsi)); % (252)
lambda  = (1-sigma_c)*U/(C-chi*C/(1+g))-betta*chi*(1-sigma_c)*U/(1+g)^(1-sigma_c)/((1+g)*C-chi*C); % (497)
UH      = -(1-sigma_c)*U*H^apsi;

F       = Wh+UH/lambda;